unit IWCompFlash;

interface

uses
  {$IFDEF VSNET}System.ComponentModel, System.Drawing, {$ENDIF}
  Classes,
  IWControl, IWFileReference, IWTypes, IWHTMLTag, 
  IWColor, IWCompObject, IWGlobal, IWRenderContext;

type
  TIWFlashQuality = (fqLow, fqAutoLow, fqAutoHigh, fqMedium, fqHigh, fqBest);

  TIWFlashScale = (fsDefault, fsShowAll, fsNoBorder, fsExactFit);

  TIWFlashAlign = (faNone, faLeft, faTop, faRight, faBottom);

  TIWFlashSAlign = (fsNone, fsLeft, fsTop, fsRight, fsBottom, fsTopLeft, fsTopRight, fsBottomLeft
   , fsBottomRight);

  TIWCustomFlash = class(TIWCustomObject)
  protected
    FAlign: TIWFlashAlign;
    FAutoPlay: Boolean;
    FBGColor: TIWColor;
    FEnableMenu: Boolean;
    FFlashFile: TIWFileReference;
    FLoop: Boolean;
    FQuality: TIWFlashQuality;
    FSAlign: TIWFlashSAlign;
    FScale: TIWFlashScale;
    FSWLiveConnect: Boolean;
    //
    procedure SetFlashFile(const AValue: TIWFileReference);

    procedure InitControl; override;
  {$IFDEF CLR}
  strict protected
  {$ELSE}
  protected
  {$ENDIF}
    procedure Dispose(ADispose: Boolean); override;
  public
    function RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag; override;

    property Align: TIWFlashAlign read FAlign write FAlign;
    property AutoPlay: Boolean read FAutoPlay write FAutoPlay;
    property BGColor: TIWColor read FBGColor write FBGColor;
    property EnableMenu: Boolean read FEnableMenu write FEnableMenu;
    {$IFDEF VSNET}
    [DesignerSerializationVisibility(DesignerSerializationVisibility.Content)]
    {$ENDIF}
    property FlashFile: TIWFileReference read FFlashFile write SetFlashFile;
    property Loop: Boolean read FLoop write FLoop;
    property Quality: TIWFlashQuality read FQuality write FQuality;
    property SAlign: TIWFlashSAlign read FSAlign write FSAlign;
    property Scale: TIWFlashScale read FScale write FScale;
    property SWLiveConnect: Boolean read FSWLiveConnect write FSWLiveConnect;
  end;

  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWFlash.bmp}  
  TIWFlash = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWFlash), 'TIWFlash.bmp')]
  {$ENDIF}
  TIWFlash = class(TIWCustomFlash)
  published
    property Align;
    property AutoPlay;
    property BGColor;
    property EnableMenu;
    property FlashFile;
    property FriendlyName;
    property Height;
    property Loop;
    property Quality;
    property SAlign;
    property Scale;
    property SWLiveConnect;
    property Width;
  end;

implementation

uses
  {$IFDEF Linux}QGraphics,{$ELSE}Graphics,{$ENDIF}
  SysUtils,
  SWSystem;

function QualityText(const AQuality: TIWFlashQuality): string;
begin
  case AQuality of
    fqLow: Result := 'Low';
    fqAutoLow: Result := 'AutoLow';
    fqAutoHigh: Result := 'AutoHigh';
    fqMedium: Result := 'Medium';
    fqHigh: Result := 'High';
    fqBest: Result := 'Best';
  end;
end;

function AlignText(AAlign: TIWFlashAlign): string;
begin
  case AAlign of
    faNone: Result := 'None';
    faLeft: Result := 'Left';
    faTop: Result := 'Top';
    faRight: Result := 'Right';
    faBottom: Result := 'Bottom';
  end;
end;

function SAlignText(ASAlign: TIWFlashSAlign): string;
begin
  case ASAlign of
    fsNone: Result := 'None';
    fsLeft: Result := 'Left';
    fsTop: Result := 'Top';
    fsRight: Result := 'Right';
    fsBottom: Result := 'Bottom';
    fsTopLeft: Result := 'TopLeft';
    fsTopRight: Result := 'TopRight';
    fsBottomLeft: Result := 'BottomLeft';
    fsBottomRight: Result := 'BottomRight';
  end;
end;

function ScaleText(AScale: TIWFlashScale): string;
begin
  case AScale of
    fsDefault: Result := 'Default';
    fsShowAll: Result := 'ShowAll';
    fsNoBorder: Result := 'NoBorder';
    fsExactFit: Result := 'ExactFit';
  end;
end;

{ TIWCustomFlash }

procedure TIWCustomFlash.InitControl;
begin
  inherited;
  FAutoPlay := True;
  FBGColor := fromTColor(clNone);
  FEnableMenu := True;
  FFlashFile := TIWFileReference.Create;
  FLoop := True;
  FQuality := fqHigh;
  Width := 468;
  Height := 60;
  FClassID := 'clsid:D27CDB6E-AE6D-11cf-96B8-444553540000';
  FCodeBase := 'http://active.macromedia.com/flash5/cabs/swflash.cab#version=5,0,0,0';
  FPluginsPage := 'http://www.macromedia.com/shockwave/download/index.cgi?P1_Prod_Version=ShockwaveFlash';
end;

procedure TIWCustomFlash.Dispose(ADispose: Boolean);
begin
  FreeAndNil(FFlashFile);
  inherited;
end;

function TIWCustomFlash.RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag;
begin
  RenderEMBED := AContext.Browser <> brIE;
  FParams.Clear;
  with FParams.Add do begin
    Name := 'MOVIE';
    Value := FlashFile.Location(GServerController.FilesURL);
    FFileReference := Value;
  end;
  with FParams.Add do begin
    Name := 'PLAY';
    Value := IIF(AutoPlay, 'TRUE', 'FALSE');
  end;
  with FParams.Add do begin
    Name := 'LOOP';
    Value := IIF(Loop, 'TRUE', 'FALSE');
  end;
  with FParams.Add do begin
    Name := 'QUALITY';
    Value := QualityText(Quality);
  end;
  with FParams.Add do begin
    Name := 'MENU';
    Value := IIF(EnableMenu, 'TRUE', 'FALSE');
  end;
  with FPArams.Add do begin
    Name := 'BGCOLOR';
    Value := ColorToRGBString(BGColor);
  end;
  with FParams.Add do begin
    Name := 'ALIGN';
    Value := AlignText(Align);
  end;
  with FParams.Add do begin
    Name := 'SALIGN';
    Value := SAlignText(SAlign);
  end;
  with FParams.Add do begin
    Name := 'SCALE';
    Value := ScaleText(Scale);
  end;
  with FParams.Add do begin
    Name := 'SWLIVECONNECT';
    Value := IIF(SWLiveConnect, 'TRUE', 'FALSE');
  end;
  Result := inherited RenderHTML(AContext);
end;

procedure TIWCustomFlash.SetFlashFile(const AValue: TIWFileReference);
begin
  FFlashFile.Assign(AValue);
end;

end.
